/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.mybaitslog.action;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.plugins.mybaitslog.icons.Icons;
import com.plugins.mybaitslog.util.ConfigUtil;
import com.plugins.mybaitslog.util.PrintlnUtil;
import com.plugins.mybaitslog.util.SqlProUtil;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class RestoreSqlForSelection
extends AnAction {
    public RestoreSqlForSelection() {
        super(Icons.MyBatisIcon);
    }

    public void actionPerformed(AnActionEvent e) {
        String[] selectedRowText;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        CaretModel caretModel = Objects.requireNonNull((Editor)e.getData(LangDataKeys.EDITOR)).getCaretModel();
        Caret currentCaret = caretModel.getCurrentCaret();
        String selectedText = currentCaret.getSelectedText();
        ConfigUtil.setShowMyBatisLog(project);
        String preparing = ConfigUtil.getPreparing();
        String parameters = ConfigUtil.getParameters();
        if (StringUtils.isNotEmpty((String)selectedText) && this.isKeyWord(project, selectedText, selectedRowText = selectedText.split("\n"), preparing, parameters)) {
            this.setFormatSelectedText(project, selectedRowText, preparing, parameters);
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            RestoreSqlForSelection.$$$reportNull$$$0(0);
        }
        this.getTemplatePresentation().setEnabled(true);
    }

    private boolean isKeyWord(Project project, String selectedText, String[] selectedRowText, String preparing, String parameters) {
        if (StringUtils.isNotBlank((String)selectedText) && selectedText.contains(preparing) && selectedText.contains(parameters) && selectedRowText.length >= 2) {
            return true;
        }
        PrintlnUtil.println(project, "", ConsoleViewContentType.USER_INPUT);
        PrintlnUtil.println(project, "\u6ca1\u6709\u53ef\u4ee5\u683c\u5f0f\u5316\u5185\u5bb9", ConsoleViewContentType.USER_INPUT, true);
        return false;
    }

    private void setFormatSelectedText(Project project, String[] selectedRowText, String preparing, String parameters) {
        String preparingLine = "";
        String parametersLine = "";
        for (int i = 0; i < selectedRowText.length; ++i) {
            String currentLine = selectedRowText[i];
            if (currentLine.contains(preparing)) {
                preparingLine = currentLine;
                continue;
            }
            if (StringUtils.isEmpty((String)preparingLine) || !currentLine.contains(parameters)) continue;
            parametersLine = currentLine;
            if (StringUtils.isNotEmpty((String)preparingLine) && StringUtils.isNotEmpty((String)parametersLine)) {
                String[] restoreSql = SqlProUtil.restoreSql(preparingLine, parametersLine);
                PrintlnUtil.println(project, "--  " + restoreSql[0], ConsoleViewContentType.USER_INPUT);
                PrintlnUtil.printlnSqlType(project, restoreSql[1]);
                continue;
            }
            PrintlnUtil.println(project, "", ConsoleViewContentType.USER_INPUT);
            PrintlnUtil.println(project, "\u6ca1\u6709\u53ef\u4ee5\u683c\u5f0f\u5316\u5185\u5bb9", ConsoleViewContentType.USER_INPUT, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/plugins/mybaitslog/action/RestoreSqlForSelection", "update"));
    }
}

