/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.mybaitslog.filter;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.plugins.mybaitslog.util.ConfigUtil;
import com.plugins.mybaitslog.util.PrintlnUtil;
import com.plugins.mybaitslog.util.SqlProUtil;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.Nullable;

public class MyBatisLogFilter
implements Filter {
    private final Project project;
    private static String preparingLine = "";
    private static String parametersLine = "";

    public MyBatisLogFilter(Project project) {
        this.project = project;
    }

    @Nullable
    public Filter.Result applyFilter(String currentLine, int endPoint) {
        if (this.project == null) {
            return null;
        }
        boolean startup = ConfigUtil.getStartup();
        if (startup && currentLine != null) {
            this.prints(currentLine, endPoint);
        }
        return null;
    }

    private void prints(String currentLine, int endPoint) {
        String preparing = ConfigUtil.getPreparing();
        String parameters = ConfigUtil.getParameters();
        if (currentLine.contains(preparing)) {
            preparingLine = currentLine;
        }
        if (!StringUtils.isEmpty((String)preparingLine) && currentLine.contains(parameters)) {
            parametersLine = currentLine;
        }
        if (StringUtils.isNotEmpty((String)preparingLine) && StringUtils.isNotEmpty((String)parametersLine)) {
            String[] restoreSql = SqlProUtil.restoreSql(preparingLine, parametersLine);
            PrintlnUtil.println(this.project, "--  " + restoreSql[0], ConsoleViewContentType.USER_INPUT);
            PrintlnUtil.printlnSqlType(this.project, restoreSql[1]);
            preparingLine = "";
            parametersLine = "";
        }
    }
}

