/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.mybaitslog.util;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.plugins.mybaitslog.util.SqlProUtil;
import java.awt.Color;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PrintlnUtil {
    public static Map<String, ConsoleView> consoleViewMap = new ConcurrentHashMap<String, ConsoleView>();

    public static void setConsoleView(Project project, ConsoleView consoleView) {
        consoleViewMap.put(project.getBasePath(), consoleView);
    }

    public static void println(Project project, String rowLine, ConsoleViewContentType consoleViewContentType) {
        PrintlnUtil.println(project, rowLine, consoleViewContentType, false);
    }

    public static void println(Project project, String rowLine, ConsoleViewContentType consoleViewContentType, boolean line) {
        PrintlnUtil.println(project, rowLine, consoleViewContentType, line, true);
    }

    public static void println(Project project, String rowLine, ConsoleViewContentType consoleViewContentType, boolean line, boolean lineBreak) {
        ConsoleView consoleView = consoleViewMap.get(project.getBasePath());
        if (consoleView != null) {
            if (lineBreak) {
                consoleView.print(rowLine + "\n", consoleViewContentType);
            } else {
                consoleView.print(rowLine, consoleViewContentType);
            }
            if (line) {
                consoleView.print(" ", ConsoleViewContentType.USER_INPUT);
            }
        }
    }

    public static void printlnSqlType(Project project, String rowLine) {
        String sqlType;
        switch (sqlType = SqlProUtil.getSqlType(rowLine)) {
            case "insert": 
            case "update": {
                PrintlnUtil.println(project, rowLine, ConsoleViewContentType.SYSTEM_OUTPUT, true);
                break;
            }
            case "delete": {
                PrintlnUtil.println(project, rowLine, new ConsoleViewContentType("styleName", new TextAttributes(Color.RED, null, null, null, 0)), true);
                break;
            }
            default: {
                PrintlnUtil.println(project, rowLine, ConsoleViewContentType.ERROR_OUTPUT, true);
            }
        }
    }
}

