/*
 * Decompiled with CFR 0.152.
 */
package com.plugins.mybaitslog.util;

import com.plugins.mybaitslog.util.BasicFormatter;
import com.plugins.mybaitslog.util.ConfigUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SqlProUtil {
    private static final BasicFormatter BASIC_FORMATTER = new BasicFormatter();
    private static final Pattern PSingleQuotationMark = Pattern.compile("'");
    private static final String Separate = "(\\(.*?\\))?,\\s";
    private static final String Separate_Substring = "substring\\((.+)\\,('|\")(.+)('|\")\\)";
    private static final Pattern PSeparate = Pattern.compile("(\\(.*?\\))?,\\s");
    private static final Pattern PSubstring = Pattern.compile("substring\\((.+)\\,('|\")(.+)('|\")\\)");
    public static Boolean Ellipsis = false;

    public static String getSqlType(String sql) {
        if (StringUtils.isNotBlank((String)sql)) {
            String lowerLine = sql.toLowerCase().trim();
            if (lowerLine.startsWith("insert")) {
                return "insert";
            }
            if (lowerLine.startsWith("update")) {
                return "update";
            }
            if (lowerLine.startsWith("delete")) {
                return "delete";
            }
            if (lowerLine.startsWith("select")) {
                return "select";
            }
        }
        return "";
    }

    public static String[] restoreSql(String preparingLine, String parametersLine) {
        String PREPARING = ConfigUtil.getPreparing();
        String PARAMETERS = ConfigUtil.getParameters();
        return SqlProUtil.restoreSql(PREPARING, PARAMETERS, preparingLine, parametersLine);
    }

    public static String[] restoreSql(String PREPARING, String PARAMETERS, String preparingLine, String parametersLine) {
        String[] preparingLineSplit = preparingLine.split(PREPARING);
        String[] parametersLineSplit = parametersLine.split(PARAMETERS);
        Object[] preparing = SqlProUtil.getPreparing(preparingLineSplit);
        Object[] parameters = SqlProUtil.getParameters(parametersLineSplit);
        try {
            String sqlformat;
            String sqlformatLike = SqlProUtil.ProcessLikeSymbol(String.format((String)preparing[1], parameters));
            String result = sqlformat = SqlProUtil.ProcessSubstringSymbol(sqlformatLike, (HashMap)preparing[2]);
            if (!Ellipsis.booleanValue()) {
                result = BASIC_FORMATTER.format(result);
            }
            return new String[]{(String)preparing[0], result};
        }
        catch (Exception e) {
            String result = BASIC_FORMATTER.format((String)preparing[1]);
            return new String[]{(String)preparing[0], result};
        }
    }

    private static String ProcessLikeSymbol(String preparing) {
        return preparing.replaceAll("\u222e\u221d\u2030#\u2030\u221d\u222e", "%");
    }

    private static String ProcessSubstringSymbol(String preparing, HashMap<Object, Object> hashMap) {
        for (Map.Entry<Object, Object> entry : hashMap.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            preparing = preparing.replaceAll(val, key);
        }
        return preparing;
    }

    private static Object[] getPreparing(String[] preparingLineSplit) {
        String one = "";
        String tow = "";
        HashMap d = null;
        if (preparingLineSplit.length == 2) {
            one = preparingLineSplit[0];
            tow = preparingLineSplit[1].replaceAll("%", "\u222e\u221d\u2030#\u2030\u221d\u222e");
            Object[] objects = SqlProUtil.ReplaceSubstringSymbol(tow);
            tow = ((String)objects[0]).replaceAll("\\?", "%s");
            d = (HashMap)objects[1];
        }
        return new Object[]{one, tow, d};
    }

    private static Object[] ReplaceSubstringSymbol(String preparing) {
        Matcher matcher = PSubstring.matcher(preparing);
        HashMap<String, String> d = new HashMap<String, String>();
        int i = 0;
        while (matcher.find()) {
            String group = matcher.group();
            String groupreplace = "\u222e\u221d\u2030Substring" + i + "\u2030\u221d\u222e";
            d.put(group, groupreplace);
            preparing = preparing.replace(group, groupreplace);
            ++i;
        }
        return new Object[]{preparing, d};
    }

    private static Object[] getParameters(String[] parametersLineSplit) {
        if (parametersLineSplit.length == 2) {
            String[] split = parametersLineSplit[1].split(Separate);
            Matcher matcher = PSeparate.matcher(parametersLineSplit[1]);
            ArrayList<String> params = new ArrayList<String>();
            for (String item : split) {
                String group = "";
                if (matcher.find()) {
                    group = matcher.group().replaceAll(",", "").trim();
                }
                String s = item.trim();
                String[] parametersTypeOrValue = SqlProUtil.getParametersTypeOrValue(s + group);
                String stringformat = SqlProUtil.quotationTypeFormat(parametersTypeOrValue);
                params.add(stringformat);
            }
            return params.toArray(new String[0]);
        }
        return new String[0];
    }

    private static String quotationTypeFormat(String[] parametersTypeOrValue) {
        String[] d;
        for (String s : d = new String[]{"String", "Timestamp", "Date", "Time", "LocalDate", "LocalTime", "LocalDateTime"}) {
            if (!s.equals(parametersTypeOrValue[1])) continue;
            return String.format("'%s'", parametersTypeOrValue[0]);
        }
        return parametersTypeOrValue[0];
    }

    private static String[] specialTypesOfEscapeFormat(String[] parametersTypeOrValue) {
        String value;
        String type = parametersTypeOrValue[1];
        String s = value = parametersTypeOrValue[0];
        if ("String".equals(type)) {
            Matcher matcher1 = PSingleQuotationMark.matcher(value);
            s = matcher1.replaceAll("\\\\'");
        }
        return new String[]{s, type};
    }

    private static String[] getParametersTypeOrValue(String s) {
        char c = '(';
        if (s.endsWith(")")) {
            char[] value = s.toCharArray();
            int find = -1;
            for (int j = value.length - 1; j >= 0; --j) {
                if (value[j] != c) continue;
                find = j;
                break;
            }
            if (find >= 0) {
                String val = s.substring(0, find);
                String type = s.substring(find + 1, value.length - 1);
                return new String[]{val, type};
            }
        }
        return new String[]{s, ""};
    }
}

